//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQml   2.12
import QtQuick 2.12
import QtQuick.Layouts 1.0
import QtQuick.Controls 1.4

import wesual.Create 1.0
import wesual.Ui     1.0

import wesual.data.Core 1.0

UiDialog {
    id : dialog

    property QtObject currentRequest

    label : qsTrId("fc09616626873896")
    instructionText : qsTrId("89f7e5e5452b8f06")
    flags : UiDialog.RejectOnEscape | UiDialog.RejectOnCloseEvent

    contentDelegate : StackView {
        id : stackView

        implicitWidth : 600
        implicitHeight : 500

        initialItem : listView
        clip : true

        Component {
            id : listView

            Item {
                UiVerticalScrollView {
                    anchors{
                        fill : parent
                        leftMargin : 15
                        rightMargin : 15
                    }

                    scrollbarOffset : -14

                    Column {
                        spacing : 5

                        width : parent.width
                        topPadding : 10
                        bottomPadding : 10

                        Repeater {
                            id : documentRepeater

                            model :  dialog.currentRequest ?
                                         dialog.currentRequest.referenced : []

                            delegate : ColumnLayout {
                                readonly property Document document :
                                    modelData.document

                                width : parent.width
                                spacing : 8

                                UiHorizontalSeparator {
                                    Layout.fillWidth : true
                                    Layout.topMargin : 2
                                    visible : index > 0
                                }

                                Row {
                                    spacing : 15
                                    Layout.fillWidth : true

                                    UiCheckBox {
                                        anchors.verticalCenter :
                                            parent.verticalCenter

                                        bindable : true
                                        checked :
                                            currentRequest.checkboxFunctions(
                                                modelData, "find") === -1

                                        onClicked : {
                                            if (checked) {
                                                currentRequest.
                                                checkboxFunctions(
                                                            modelData, "add");
                                            } else {
                                                currentRequest.
                                                checkboxFunctions(modelData,
                                                                  "remove");
                                            }
                                        }

                                    }

                                    Loader {
                                        anchors.verticalCenter :
                                            parent.verticalCenter

                                        sourceComponent : {
                                            switch (document.type) {
                                            case "area":
                                                return areaDelegate;
                                            case "areagroup":
                                                return areaGroupDelegate;
                                            case "asset:image":
                                            case "asset:pdf":
                                            case "asset:video":
                                                return mediaDelegate;
                                            default:
                                                return null;
                                            }
                                        }

                                        Component {
                                            id : areaDelegate

                                            AreaDependencyDelegate {
                                                area : document
                                            }
                                        }

                                        Component {
                                            id : areaGroupDelegate

                                            AreaGroupDependencyDelegate {
                                                group : document
                                            }
                                        }

                                        Component {
                                            id : mediaDelegate

                                            MediaDependencyDelegate {
                                                asset : document
                                            }
                                        }
                                    }

                                    Column {
                                        spacing : 4
                                        anchors.verticalCenter :
                                            parent.verticalCenter
                                        UiText {
                                            text : document.type === "area" ?
                                                       document.name :
                                                       document.label
                                        }

                                        UiCommandLink {
                                            text : qsTrId("ccf868b928db1e3d",
                                                       modelData.dependantCount)

                                            onClicked : stackView.push(
                                                            { item : detailView,
                                                              properties : {
                                                                    document :
                                                                    modelData.
                                                                    document
                                                                }
                                                            })
                                        }
                                    }
                                }
                            }
                        }

                        Repeater {
                            model :  dialog.currentRequest ?
                                         dialog.currentRequest.locked : []

                            delegate : ColumnLayout {
                                readonly property Document document :
                                    modelData.document

                                width : parent.width
                                spacing : 8

                                UiHorizontalSeparator {
                                    Layout.fillWidth : true
                                    Layout.topMargin : 2
                                    visible :
                                        ((currentRequest.referenced.length > 0)
                                         && (index < 1)) || (index > 0)

                                }

                                Row {
                                    spacing : 15
                                    Layout.fillWidth : true

                                    UiCheckBox {
                                        anchors.verticalCenter :
                                            parent.verticalCenter

                                        enabled : false
                                        checked : false
                                    }
                                    Loader {
                                        anchors.verticalCenter :
                                            parent.verticalCenter

                                        sourceComponent : {
                                            switch (document.type) {
                                            case "area":
                                                return areaDelegate;
                                            case "areagroup":
                                                return areaGroupDelegate;
                                            case "asset:image":
                                            case "asset:pdf":
                                            case "asset:video":
                                                return mediaDelegate;
                                            default:
                                                return null;
                                            }
                                        }

                                        Component {
                                            id : areaDelegate

                                            AreaDependencyDelegate {
                                                area : document
                                            }
                                        }

                                        Component {
                                            id : areaGroupDelegate

                                            AreaGroupDependencyDelegate {
                                                group : document
                                            }
                                        }

                                        Component {
                                            id : mediaDelegate

                                            MediaDependencyDelegate {
                                                asset : document
                                            }
                                        }
                                    }
                                    Column {
                                        spacing : 4
                                        anchors.verticalCenter :
                                            parent.verticalCenter

                                        UiText {
                                            text : document.type === "area" ?
                                                       document.name :
                                                       document.label
                                        }

                                        UiCommandLink {
                                            visible : modelData.referenced
                                            enabled : modelData.referenced

                                            text : qsTrId("ccf868b928db1e3d",
                                                    modelData.dependantCount)

                                            onClicked :
                                                stackView.push(
                                                    { item : detailView,
                                                      properties : {
                                                            document :
                                                            modelData.document
                                                        }
                                                    });
                                        }

                                        Row {
                                            spacing : 5
                                            UiText {
                                                text : qsTrId("2e30a55d9c53a720")
                                                anchors.verticalCenter :
                                                    parent.verticalCenter
                                            }
                                            UiInfoIcon {
                                                infoTip : qsTrId("a5b539e0b67f7a25")
                                                anchors.verticalCenter :
                                                    parent.verticalCenter
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        Component {
            id : detailView

            Item {
                property alias document : incoming.document

                UiVerticalScrollView {
                    anchors {
                        fill : parent
                        leftMargin   : 15
                        rightMargin  : 15
                    }

                    scrollbarOffset : -14

                    ColumnLayout {
                        RowLayout {
                            spacing : 4

                            Layout.topMargin : 10

                            UiToolButton {
                                iconName : "back-arrow"

                                onClicked : stackView.pop()
                            }

                            UiText {
                                id : label

                                text : qsTrId("b698b72e8522cf6f")
                                font : UiFonts.getFont(UiFonts.Light, 16)

                                Layout.fillWidth : true
                            }
                        }

                        DependencyView {
                            id : incoming

                            direction : DocumentDependencies.Incoming
                            supportsContextMenu : false
                        }

                        Item {
                            Layout.minimumHeight : 10
                            Layout.fillWidth  : true
                            Layout.fillHeight : true
                        }
                    }
                }
            }
        }
    }

    buttons : [
        UiDialogButton {
            text : qsTrId("8df137f132f37298")
            enabled   : currentRequest && ((currentRequest.unchecked.length <
                                            currentRequest.referenced.length) ||
                                            currentRequest.unchecked.length < 1)

            action    : UiDialogButton.NoAction
            onClicked : {
                currentRequest.deleteAll();
                dialog.accept(true);
            }
        },
        UiDialogButton {
            text : qsTrId("9484311cb9072a4d")
            visible   : currentRequest &&
                        (currentRequest.unreferenced.length > 0)
            enabled   : currentRequest &&
                        (currentRequest.unreferenced.length > 0)

            action    : UiDialogButton.NoAction
            style     : Ui.PrimaryPushButtonStyle
            onClicked : {
                currentRequest.deleteUnreferenced();
                dialog.accept(true);
            }
        },
        UiDialogButton { role : UiDialogButton.CloseRole }
    ]
}
